/*
 * Die Sourcecodes, die diesem Buch als Beispiele beiliegen, sind
 * Copyright (c) 2006 - Thomas Ekert. Alle Rechte vorbehalten.
 * 
 * Trotz sorgfltiger Kontrolle sind Fehler in Softwareprodukten nie vollstndig auszuschlieen.
 * Die Sourcodes werden in Ihrem Originalzustand ausgeliefert.
 * Ansprche auf Anpassung, Weiterentwicklung, Fehlerbehebung, Support
 * oder sonstige wie auch immer gearteten Leistungen oder Haftung sind ausgeschlossen.
 * Sie drfen kommerziell genutzt, weiterverarbeitet oder weitervertrieben werden.
 * Voraussetzung hierfr ist, dass fr jeden beteiligten Entwickler, jeweils mindestens
 * ein Exemplar dieses Buches in seiner aktuellen Version als gekauftes Exemplar vorliegt.
 */
package djbuch.kapitel_05;
import lotus.domino.*; import org.omg.CORBA.ORB;

/**
 * Domino DIIOP Connection POOL<br>
 * Um die Synchronisation nur noch auf den Pool, nicht mehr auf <br>
 * die gesamte Servlet Klasse (die den Pool benutzt) beziehen zu mssen, <br> 
 * wurde der Pool in diese Klasse ausgelagert. <br>
 * Der Pool wird als statisches Objekt im Servlet angelegt <br>
 * Der ORB selbst ist jedoch nicht statisch, sondern Instanzvariable <br>
 * in der Klasse ConnectionPool
 * 
 * @author Thomas Ekert
 */
public class ConnectionPool {

	private static final int MAX_SESSION_IN_POOL = 10;
	private static final String DEFAULT_HOST="www.djbuch.de:63148";
	private static final ConnectionPool singletonPool = new ConnectionPool ();
	private ORB brooker = null;
	private int orbCount = 0;
	private int concurrentOrbCount = 0;
	private String token = null;
	private String host = null;
	
	private ConnectionPool () {
		this.host = DEFAULT_HOST;
	}
	
	public static ConnectionPool getConnectionPool () {
		return singletonPool;
	}
	
	/**
	 * @return - Liefert eine Notes Session. Fhrt einen Retry durch, falls <br>
	 * beim ersten Versuch eine NotesException auftritt. <br>
	 * @throws NotesException
	 */
	public Session getSession() throws NotesException {
		Session session = null;
		try {
			session = NotesFactory.createSession(host, this.getBrooker(), this.getToken(false));
		} catch (NotesException e) {
			System.err.println ("TOKEN INVALID OR NO SESSION AVAILABLE " + this.getCount());
			session = NotesFactory.createSession(host, this.getBrooker(), this.getToken(true));			
		}
		return session;
	}
	
	/**
	 * @return - Liefert einen Object Request Brooker, falls mehr als 10 Sitzungen <br>
	 * offen sind, sonst den bereits erstellten, sofern vorhanden.
	 */
	private ORB getBrooker() {
		synchronized (this) {
			orbCount+=1;
			if ((brooker == null) || ((orbCount % MAX_SESSION_IN_POOL) == 0)) {
				brooker = NotesFactory.createORB();
				concurrentOrbCount=1;
				System.out.println(brooker.getClass() + " wurde erstellt.");
			} else {
				concurrentOrbCount++;
			}
		}
		return brooker;
	}
	
	/**
	 * Das LtpaToken wird, falls noch nicht vorhanden, <br>
	 * durch einen expliziten Login berechnet und dann wiederverwendet. <br>
	 * Wirft eine NotesException, falls etwas nicht klappt.
	 * @throws NotesException
	 */
	synchronized private String getToken (boolean enforce) throws NotesException {
		if (!enforce && token != null && !token.equals ("")) {
			return token;
		} else {
			Session tempSession = null;
			try {
				tempSession = NotesFactory.createSession(host, "Administrator","geheim");
				token = tempSession.getSessionToken();
				return token;
			} finally {
				recycleSession(tempSession);
			}
		}
	}
	
	/** 
	 * Zeigt den aktuellen LtpaToken, ohne ihn neu zu beziehen.
	 * @return
	 */
	public String showToken () {
		return token;
	}
	
	/**
	 * Anzahl der bereits ber diesen Pool jemals geffneten 
	 * Connections.
	 * Beachte: Wird nicht zurckgesetzt, wenn ein neuer ORB erzeugt wird.
	 * @return
	 */
	public int getCount () {
		return orbCount;
	}
	
	/**
	 * Anzahl der ber diesen ORB gehandelten Sessions.
	 * @return
	 */
	public int getConcurrentCount () {
		return concurrentOrbCount;
	}
	
	/**
	 * Wurde aus Bequemlichkeit als statische Utility in die <br>
	 * Klasse ConnectionPool verschoben
	 * @param s - Notes Session, die recycled werden soll.
	 */
	public static void recycleSession (Session s) {
		try {
			if (s!= null && s.isValid()) {
				s.recycle ();
			}
		} catch (org.omg.CORBA.INV_OBJREF e) {
			//e.printStackTrace(); //ignore. Server might already have closed DIIOP.
		} catch (NotesException e) {
			e.printStackTrace();
		}
	}
}
